open VecOps

let abs2 (a, b) = 
  sqrt (a ** 2.0 +. b ** 2.0)

let unit (x, y) =
  if x <> 0.0 || y <> 0.0 then
    let l = abs2 (x, y) in
      (x, y) *|. (1.0 /. l, 1.0 /. l)
  else
    (0.0, 0.0)

let dup (a : float) = a, a

let v2 a = a, a

let v3 a = a, a, a

let coaxel (x, y) =
  (0.0 -. y, x)

let base (x, y) = 
  ((x, y), coaxel (x, y))

let inverse ((a, b), (c, d)) =
  let v = 1.0 /. (a *. d -. b *. c) in
    ((v *. d, -.v *. b), (-.v *. c, v *. a))

let dot (a, b) (c, d) =
  a *. c +. b *. d

let int2 (a, b) = int_of_float a, int_of_float b
let float2 (a, b) = float a, float b
let round2 (a, b) = int_of_float (a +. 0.5), int_of_float (b +. 0.5)

let int3 (a, b, c) = int_of_float a, int_of_float b, int_of_float c
let float3 (a, b, c) = float a, float b, float c
let round3 (a, b, c) = int_of_float (a +. 0.5), int_of_float (b +. 0.5), int_of_float (c +. 0.5)

let f_to_string (a, b) = Printf.sprintf "%f,%f" a b
