include GobaMath

let ( +| ) (x1, y1) (x2, y2) =
  (x1 + x2, y1 + y2)

let ( -| ) (x1, y1) (x2, y2) =
  (x1 - x2, y1 - y2)

let ( *| ) (x1, y1) (x2, y2) =
  (x1 * x2, y1 * y2)

let ( /| ) (x1, y1) (x2, y2) =
  (x1 / x2, y1 / y2)

let ( +|| ) (x1, y1, z1) (x2, y2, z2) =
  (x1 + x2, y1 + y2, z1 + z2)

let ( /|| ) (x1, y1, z1) (x2, y2, z2) =
  (x1 / x2, y1 / y2, z1 / z2)

let ( *|| ) (x1, y1, z1) (x2, y2, z2) =
  (x1 * x2, y1 * y2, z1 * z2)

let ( -|| ) (x1, y1, z1) (x2, y2, z2) =
  (x1 - x2, y1 - y2, z1 - z2)

let ( +|. ) (x1, y1) (x2, y2) =
  (x1 +. x2, y1 +. y2)

let ( -|. ) (x1, y1) (x2, y2) =
  (x1 -. x2, y1 -. y2)

let ( *|. ) (x1, y1) (x2, y2) =
  (x1 *. x2, y1 *. y2)

let ( /|. ) (x1, y1) (x2, y2) =
  (x1 /. x2, y1 /. y2)

let ( +||. ) (x1, y1, z1) (x2, y2, z2) =
  (x1 +. x2, y1 +. y2, z1 +. z2)

let ( -||. ) (x1, y1, z1) (x2, y2, z2) =
  (x1 -. x2, y1 -. y2, z1 -. z2)

let ( *||. ) (x1, y1, z1) (x2, y2, z2) =
  (x1 *. x2, y1 *. y2, z1 *. z2)

let ( /||. ) (x1, y1, z1) (x2, y2, z2) =
  (x1 /. x2, y1 /. y2, z1 /. z2)

let ( +|||. ) (x1, y1, z1, a1) (x2, y2, z2, a2) =
  (x1 +. x2, y1 +. y2, z1 +. z2, a1 +. a2)

let ( *|||. ) (x1, y1, z1, a1) (x2, y2, z2, a2) =
  (x1 *. x2, y1 *. y2, z1 *. z2, a1 *. a2)

let ( -|||. ) (x1, y1, z1, a1) (x2, y2, z2, a2) =
  (x1 -. x2, y1 -. y2, z1 -. z2, a1 -. a2)

let ( /|||. ) (x1, y1, z1, a1) (x2, y2, z2, a2) =
  (x1 /. x2, y1 /. y2, z1 /. z2, a1 /. a2)

let ( **|. ) (x, y) ((a, b), (c, d)) =
  ( x *. a +. y *. b ), (x *. c +. y *. d)
