SEXP_CONV_PATH "Goba"

type tile_info =
    { hp : int }
with sexp

type tile = 
  | Space
  | Mountain
  | Grass
  | Water
  | Wall
  | Start of int
with sexp

type t = tile * tile_info
with sexp

let (tile_of_char, char_of_tile) = 
  let mapping = 
    [' ', Space;
     '%', Grass;
     '~', Water;
     '@', Mountain;
     '#', Wall;
     '0', Start 0;
     '1', Start 1;
     '2', Start 2;
     '3', Start 3;
     '4', Start 4;
     '5', Start 5;
     '6', Start 6;
     '7', Start 7;
     '8', Start 8;
     '9', Start 9;
    ]
  in
  let mapping_rev = List.map (fun (a, b) -> (b, a)) mapping in
    ((fun ch -> List.assoc ch mapping),
     (fun tile -> List.assoc tile mapping_rev))

let tile_with_info t =
  let info =
    match t with 
      | Grass -> { hp = 10 }
      | Mountain -> { hp = 100 }
      | _ -> { hp = 999 }
  in
    (t, info)

let empty =
  (Space, { hp = 0 })
