let find_sample = 
  let samples = Hashtbl.create 10 in
    fun name ->
      try Hashtbl.find samples name 
      with Not_found ->
	let filename = "sfx/" ^ name ^ ".wav" in
	let _ = Printf.printf "Loading %s\n%!" filename in
	let s = Sdlmixer.loadWAV filename in
	  Hashtbl.add samples name s;
	  s

class channel (Sfx.Channel n) : Sfx.channel =
object
  method playing = Sdlmixer.playing_channel n
  method expire t = Sdlmixer.expire_channel n t
  method play ?loops (Sfx.Sample name) = Sdlmixer.play_channel ?loops ~channel:n (find_sample name)
  method release = ()
end
