open VecOps

type faces = (char * ((int * int) * Sdlvideo.surface)) list

type t = { mutable left : faces;
	   mutable right : faces;
	   origo	: int * int }

let adjust_ofs (ofs, bitmap) adj =
  (ofs +| adj, bitmap)

let cursor_face = lazy (adjust_ofs 
			  (Bitmaps.bitmap (`Block (2, 25, (255, 255, 255), 255)))
			  (5, 5)
		       )

let create origo =
  { origo = origo;
    left = [];
    right = [] }  

let face_width face =
  let (ch, (_, surface)) = face in
    match ch with
      | ' ' -> 10
      | _ -> 
	  let (w, _h) = Gfx.surface_dims surface in 
	    max 5 w

let cur_pos t =
  List.fold_left
    (fun at face ->
       at +| (face_width face, 0)
    )
    t.origo
    t.left

let new_char t ch =
  (ch, Bitmaps.bitmap (`Char (ch, (255, 255, 255))))

let add_char t ch =
  t.left <- new_char t ch::t.left

let backspace t =
  match t.left with
    | [] -> ()
    | l::ls -> t.left <- ls

let move_left t =
  let left, right =
    match t.left, t.right with
      | [], _ -> t.left, t.right
      | l::ls, rs -> ls, l::rs
  in
    t.left <- left;
    t.right <- right

let move_right t =
  let left, right =
    match t.left, t.right with
      | _, [] -> t.left, t.right
      | ls, r::rs -> r::ls, rs
  in
    t.left <- left;
    t.right <- right

let handle t event =
  match event with
    | Sdlevent.KEYDOWN { Sdlevent.keysym = Sdlkey.KEY_RETURN } ->
	Some 
	  (String.concat "" 
	     (List.map (fun (ch, _) -> String.make 1 ch)
		(List.rev_append t.left t.right)))
    | Sdlevent.KEYDOWN { Sdlevent.keysym = Sdlkey.KEY_BACKSPACE } ->
	backspace t;
	None
    | Sdlevent.KEYDOWN { Sdlevent.keysym = Sdlkey.KEY_LEFT } ->
	move_left t;
	None
    | Sdlevent.KEYDOWN { Sdlevent.keysym = Sdlkey.KEY_RIGHT } ->
	move_right t;
	None
    | Sdlevent.KEYDOWN { Sdlevent.keycode = ch } when ch <> Char.chr 0 ->
	add_char t ch;
	None
    | _ -> None

let render t (gfx:Gfx.t) =
  let chars = List.rev t.left @ [(' ', Lazy.force cursor_face)] @ t.right in
    ignore (
      List.fold_left
	(fun at ((_, (ofs, surface)) as face) ->
	   gfx#blit (at +| ofs) surface;
	   at +| (face_width face, 0)
	)
	t.origo
	chars
    )


