{
  type token =
    | String of string
    | Separator
    | End

  let unescape_chars = 
    let basic = 
      ['n', '\n';
       't', '\t';
       'e', Char.chr 27;
      ] in
      basic @
	GobaUtils.fold1d 
	(fun v chrs ->
	   (Char.chr (Char.code '@' + v), Char.chr v)::chrs
	)
	[]
	(0, 27)

  let unescape str =
    let b = Buffer.create (String.length str) in
    let rec scan at =
      if at >= String.length str then
	()
      else
	if str.[at] = '\\' && at + 1 < String.length str then
	  begin
	    let c =
	      try List.assoc str.[at + 1] unescape_chars
	      with Not_found -> str.[at + 1]
	    in
	      Buffer.add_char b c;
	      scan (at + 2)
	  end
	else
	  begin
	    Buffer.add_char b str.[at];
	    scan (at + 1)
	  end
    in
      scan 0;
      Buffer.contents b
}

let chars = ['a'-'z' 'A'-'Z' '0'-'9' '.' '_' '!' ',']

rule message =
  parse 
    | (chars | '\\' _ )+ as lxm { String (unescape lxm) }
    | ' ' + { Separator }
    | eof { End }
