type t = { layers  : int;
	   offsets : (int * int) array;
	   amp	   : int array;
	   scales  : int array;
	   noise   : Noise.t }

let create 
    ?(layers=10)
    ?(scale=((+) 9)) 
    ?(amp=(fun _ -> 0x100 / layers)) 
    ?(offset=(fun _ -> Random.int max_int, Random.int max_int))
    () =
  { layers	= layers;
    offsets	= Array.init layers offset;
    amp		= Array.init layers amp;
    scales	= Array.init layers scale;
    noise	= Noise.create () }

let fold_n f v0 n =
  let rec aux at v =
    if at < n then
      aux (at + 1) (f v at)
    else
      v
  in
    aux 0 v0

let at t (x, y) =
  let noise at = Noise.at t.noise at in
    fold_n
      (fun value layer ->
	 let scale = t.scales.(layer) in
	   value + 
	     t.amp.(layer) * 
	     noise (x * scale + fst t.offsets.(layer), 
		    y * scale + snd t.offsets.(layer))
      )
      0
      t.layers
    lsr 8
    
