let counters = Hashtbl.create 10

let names = Hashtbl.create 10

let get_counter = 
  let c = ref 0 in
    fun name -> 
      let v = !c in
	incr c;
	Hashtbl.add counters v 0;
	Hashtbl.add names v name;
	v

let inc c v =
  Hashtbl.replace counters c (Hashtbl.find counters c + 1);
  v

let show_counters () =
  Printf.printf "Performance counters:\n";
  Hashtbl.iter
    (fun k name ->
       Printf.printf "%s: %d\n" name (Hashtbl.find counters k);
    )
    names;
  Printf.printf "%!"
