type object_id
val sexp_of_object_id : object_id -> Sexplib.Sexp.t
val object_id_of_sexp__ : Sexplib.Sexp.t -> object_id
val object_id_of_sexp : Sexplib.Sexp.t -> object_id
val object_id_of_int64 : int64 -> object_id

type map_id = int * int
val sexp_of_map_id : map_id -> Sexplib.Sexp.t
val map_id_of_sexp__ : Sexplib.Sexp.t -> map_id
val map_id_of_sexp : Sexplib.Sexp.t -> map_id

type id = 
  | MapId of map_id
  | ObjectId of object_id
val string_of_id : id -> string
val sexp_of_id : id -> Sexplib.Sexp.t
val id_of_sexp__ : Sexplib.Sexp.t -> id
val id_of_sexp : Sexplib.Sexp.t -> id

exception NotValidObjectType
val to_map_id : id -> map_id
val to_object_id : id -> object_id

type serial = Serial of int64
val next_serial : unit -> serial
val no_serial : serial
type render_flag = [ `Labels | `LabelsExcept of id list ]
type render_flags = render_flag list

class type base =
object
  (** retrieve a delayed image of this object, which may be
      provided to the clone of this object at another site *)
  method get_state : float -> Sexplib.Sexp.t

  (** assigns object state *)
  method set_state : Sexplib.Sexp.t -> float -> unit

  (** cause damage to this object *)
  method cause_damage : int -> unit

  (** flag this object has changed *)
  method change : unit

  (** has this object changed since this time? *)
  method changed_since : serial -> bool

  (** can this element be collided with? (ie. by driving a tank *)
  method collidable : bool

  (** this object has been collided: return whether the object thinks it was *)
  method collide : world -> bool

  (** return a boundary box ((x1, y1), (x2, y2)) and a collision
      mask, coordinated in the map *)
  method collision_area :
    ((float * float) * (float * float)) * CollisionMask.mask

  (** can this object be destructed? (ground tiles cannot) *)
  method destructible : bool

  (** if this object is being rolled over, how much friction does it cause? *)
  method friction : float

  (** return a game-unique identifier for this object *)
  method get_id : id

  (** this object has been hit with something by n points of damage *) 
  method impact : world -> int -> unit

  (** has this object ceased to exist? *)
  method is_alive : bool

  (** current location of the object *)
  method location : float * float

  (** how far from the ground this object is? usually 0.0 or positive *)
  method z_location : float

  (** this object is in the recharge region and is being recharged *)
  method recharge : bool

  (** render the object at the provided coordinates. Note! The location
      of the object in the map has already been taken into account! *)
  method render : Gfx.t -> render_flags -> int * int -> unit

  (** Is this object owned by the current node? Also answers to the
      question is this node responsible this its behavior *)
  method self_owned : bool

  (** flag this object self-owned by us (or not) *)
  method set_self_owned : bool -> unit

  (** what is the motion vector of this object? *)
  method speed : float * float

  (** worls ticks forward n seconds.. *)
  method tick : float -> world -> unit
end and
  world =
object
  method collision : Collision.t -> (base -> bool) -> ((float * float) * base list) option
  method explode : float * float -> float * float -> unit
  method env : Collision.t -> (base -> bool) -> base list
  method objs : (float * float) * (float * float) -> (base -> bool) -> base list
  method report_damage : id * int -> unit
  method channel : Sfx.channel_number -> Sfx.channel
end

type place_motion = ((float * float) * (float * float))

(* for the benefit of the server *)
val sexp_of_place_motion : place_motion -> Sexplib.Sexp.t
val place_motion_of_sexp__ : Sexplib.Sexp.t -> place_motion
val place_motion_of_sexp : Sexplib.Sexp.t -> place_motion

type 'a init =
  | State of (Sexplib.Sexp.t * float)
  | Init of 'a

type 'a state = { 
  state_super : Sexplib.Sexp.t; 
  state_init : 'a; 
}

val sexp_of_state : ('a -> Sexplib.Sexp.t) -> 'a state -> Sexplib.Sexp.t
val state_of_sexp__ : (Sexplib.Sexp.t -> 'a) -> Sexplib.Sexp.t -> 'a state
val state_of_sexp : (Sexplib.Sexp.t -> 'a) -> Sexplib.Sexp.t -> 'a state

val default : 'a init -> 'a -> 'a

val default_by : 'a init -> (Sexplib.Sexp.t * float -> 'a) -> 'a

val default_with : 'a init -> (Sexplib.Sexp.t -> 'a) -> 'a

class virtual t :
  object_id ->
  object
    val mutable change_serial : serial
    val mutable self_owned : bool
    method get_state : float -> Sexplib.Sexp.t
    method set_state : Sexplib.Sexp.t -> float -> unit
    method cause_damage : int -> unit
    method change : unit
    method changed_since : serial -> bool
    method collidable : bool
    method collide : world -> bool
    method virtual collision_area :
      ((float * float) * (float * float)) * CollisionMask.mask
    method destructible : bool
    method friction : float
    method get_id : id
    method impact : world -> int -> unit
    method virtual is_alive : bool
    method virtual location : float * float
    method z_location : float
    method recharge : bool
    method virtual render : Gfx.t -> render_flags -> int * int -> unit
    method self_owned : bool
    method set_self_owned : bool -> unit
    method virtual speed : float * float
    method tick : float -> world -> unit

    method private virtual set_location : float * float -> unit
    method private virtual set_speed : float * float -> unit
  end
