open GobaMath

type t = { rand2d : int array }

let cos_table =
  let a = 
    Array.init 
      256
      (fun c -> 
	 int_of_float ((cos (float c /. 256.0 *. pi) +. 1.0) /. 2.0 *. 256.0)) 
  in
    a

let create () =
  let a = Array.make (256 * 256) 0 in
    for y = 0 to 255 do
      for x = 0 to 255 do
	a.(y * 256 + x) <- Random.int 256
      done
      done;
	{ rand2d = a }

let at t (x, y) =
  let frac_x = x land 0xff in
  let frac_y = y land 0xff in
  let int_x = x lsr 8 in
  let int_y = y lsr 8 in
  let r x y = t.rand2d.((int_x + x) land 0xff + (int_y + y) land 0xff * 256) in
  let v00 = r 0 0 in
  let v10 = r 1 0 in
  let v01 = r 0 1 in
  let v11 = r 1 1 in
  let vx0 = (cos_table.(frac_y) * v00 + (256 - cos_table.(frac_y)) * v01) lsr 8 in
  let vx1 = (cos_table.(frac_y) * v10 + (256 - cos_table.(frac_y)) * v11) lsr 8 in
    (cos_table.(frac_x) * vx0 + (256 - cos_table.(frac_x)) * vx1) lsr 8
