let create_udp_socket port =
  let s = Unix.socket Unix.PF_INET Unix.SOCK_DGRAM (Unix.getprotobyname "udp").Unix.p_proto in
    try
      Unix.setsockopt s Unix.SO_REUSEADDR true;
      Unix.bind s (Unix.ADDR_INET (Unix.inet_addr_any, port));
      s
    with exn ->
      Unix.close s;
      raise exn

let create_server_socket port =
  let s = Unix.socket Unix.PF_INET Unix.SOCK_STREAM 0 in
    try
      Unix.setsockopt s Unix.SO_REUSEADDR true;
      Unix.bind s (Unix.ADDR_INET (Unix.inet_addr_any, port));
      (try Unix.bind s (Unix.ADDR_INET (Unix.inet6_addr_any, port)) with exn -> ());
      Unix.listen s 0;
      s
    with exn ->
      Unix.close s;
      raise exn

let create_client_socket address =
  let s = 
    Unix.socket 
      (match address with 
	 | Unix.ADDR_UNIX _ -> Unix.PF_UNIX 
	 | Unix.ADDR_INET (addr, _) when try ignore (String.index (Unix.string_of_inet_addr addr) ':'); true with _ -> false -> Unix.PF_INET6
	 | Unix.ADDR_INET (addr, _) -> Unix.PF_INET)
	 Unix.SOCK_STREAM 0 in
    try
      Unix.connect s address;
      s
    with exn ->
      Unix.close s;
      raise exn 
 
