open VecOps

type 'a entry = 
    { label : string;
      value : 'a; }

type 'a t = { entries		: 'a entry list;
	      mutable selected	: int;
	      mutable time	: float }

let entry label value =
  { label = label;
    value = value }

let create entries =
  { entries = entries;
    selected = 0;
    time = 0.0 }

let choose_next t =
  t.selected <- min (t.selected + 1) (List.length t.entries - 1)

let choose_prev t =
  t.selected <- max (t.selected - 1) 0

let choose t =
  (List.nth t.entries t.selected).value

let tick t delta =
  t.time <- t.time +. delta

let render t (gfx:Gfx.t) =
  ignore (
    List.fold_left
      (fun (y, nth) { label = label } ->
	 let color = 
	   if nth = t.selected then
	     (255, min 255 (max 0 (200 + int_of_float (50.0 *. sin (2.0 *. t.time)))), 255)
	   else
	     (128, 128, 128)
	 in
	 let text = gfx#text_surface ~color label in
	 let w, h = Gfx.surface_dims text in
	   gfx#blit ((800 - w) / 2, y) text;
	   (y + h + 20, nth + 1)
      )
      (100, 0)
      t.entries
  )
