let dump_map (width, height, map) =
  for y = 0 to height - 1 do
    for x = 0 to width - 1 do
      Printf.printf "%c" (map (x, y))
    done;
    Printf.printf "\n"
  done

let main () = 
  let map = MapGenerator.generate (80, 80) (11, 18) in
  let width, height = MapData.dims map in
  let twidth, theight = MapData.tile_size map in
    Printf.printf "%d\n%d\n" width height;
    Printf.printf "%d\n%d\n" twidth theight;
    dump_map (width, height, (fun at -> Tile.char_of_tile (MapData.get map at)))

let _ = 
  Random.self_init ();
  main ()
  
