open MapData

let load_map file =
  let f = open_in file in
    try
      let width = int_of_string (input_line f) in
      let height = int_of_string (input_line f) in
      let tile_width = int_of_string (input_line f) in
      let tile_height = int_of_string (input_line f) in
      let contents = Array.make (width * height) Tile.Space in 
	for y = 0 to height - 1 do
	  let line = input_line f in
	    for x = 0 to String.length line - 1 do
	      contents.(x + y * width) <- Tile.tile_of_char line.[x]
	    done;
	    done;
	      close_in f;
	      { size = width, height;
		tile_size = tile_width, tile_height;
		data = contents }
    with
	exn -> 
	  close_in f;
	  raise exn
