SEXP_CONV_PATH "Goba"
type t = { size		: int * int;
	   tile_size	: int * int;
	   data		: Tile.tile array }
with sexp

let get { size = w, h; data = data } (x, y) =
  data.(x + w * y)

let set { size = w, h; data = data } (x, y) v =
  data.(x + w * y) <- v

let dims { size = size } = size

let tile_size { tile_size = t } = t

let create ?(f=(fun _ -> Tile.Space)) (width, height) tile_size =
  { size = (width, height);
    tile_size = tile_size;
    data = 
      Array.init (width * height) 
	(fun ofs -> let at = ofs mod width, ofs / width in f at);
  }
