let alpha_rectangle surface alpha color (w, h) =
  let s = Sdlvideo.create_RGB_surface_format surface [] ~w ~h in
    Sdlvideo.fill_rect ~rect:(Sdlvideo.rect 0 0 w h) s (Sdlvideo.map_RGB s color);
    Sdlvideo.set_alpha s alpha;
    s

let render (gfx:Gfx.t) =
  let msg = 
    "
    F1       View this help.

q   w   e    Control the firing
a       d    direction. Combinations
z  x/s  c    allow more accuracy.

1  2  3  4   Choose the tank to control. 
             With shift you can choose multiple tanks!

  Arrows     Move the currently selected tank.

    m        Drop a mine.

  Return     Send messages to your opponents.

Hints: Move tank near the base to recharge/heal it!

Game objective: Destroy the enemy base!
" in
  let lines = 
    let line = ref (ref []) in
    let ls = ref [] in
      String.iter 
	(function 
	   | '\n' ->
	       ls := String.concat "" (List.map (String.make 1) (List.rev (! !line))) :: !ls;
	       line := ref []
	   | ch ->
	       !line := ch :: ! !line)
	msg;
      List.rev !ls
  in
  let next_line n msg =
    if msg = "" then
      n + 20
    else
      n + 16
  in
  let height = List.fold_left next_line 0 lines + 10 in
  let () =
    let s = alpha_rectangle gfx#get_surface 200 (0, 0, 0) (800, height) in
      gfx#blit (0, 0) s
  in
  let _ =
    List.fold_left
      (fun y line ->
	 if line <> "" then
	   begin
	     gfx#write ~size:20 (0, y) line;
	   end;
	 next_line y line)
      0
      lines
  in
    ()


