let deoption o = match o with Some o -> o | None -> failwith "No value"

let list_of_hash f h =
  Hashtbl.fold (fun key obj objs -> f key obj::objs) h []
let int_of_float2 (a, b) = (int_of_float a, int_of_float b)
let float_of_int2 (a, b) = (float_of_int a, float_of_int b)
let float2 = float_of_int2
let hashtbl_map f h =
  let h' = Hashtbl.create (Hashtbl.length h) in
    Hashtbl.iter 
      (fun key value ->
	 Hashtbl.add h' key (f value))
      h;
    h'
      
let const a b = a

let valuefy f v =
  try
    `Value (f v)
  with 
    | exn -> `Exn exn

(* note that (obviously) prematurely exiting will cause the rest of the buffer
   to be discarded *)
type buffer_process = [ `Stop | `Continue ]

let rec fix_buffer : Buffer.t -> string -> ('a -> string -> (buffer_process * 'a)) -> 'a -> 'a =
  fun buffer msg f v0 ->
    if String.length msg > 0 then
      match try Some (String.index msg '\n') with Not_found -> None with
	| Some cr_pos ->
	    begin
	      Buffer.add_substring buffer msg 0 cr_pos;
	      let c = Buffer.contents buffer in
		Buffer.clear buffer;
		let mode, value = f v0 c in
		  match mode with
		    | `Stop -> value
		    | `Continue ->
			fix_buffer buffer (String.sub msg (cr_pos + 1) (String.length msg - (cr_pos + 1))) f value
	    end
	| None ->
	    Buffer.add_string buffer msg;
	    v0
    else
      v0

let foldl1d f v0 (low, high) =
  let rec aux v at =
    if at < high then
      aux (f at v) (at + 1)
    else
      v
  in
    aux v0 low

let foldr1d f v0 (low, high) =
  let rec aux v at =
    if at >= 0 then
      aux (f at v) (at - 1)
    else
      v
  in
    aux v0 (high - 1)

let iter2d f ((x1, y1), (x2, y2)) =
  for x = x1 to x2 - 1 do
    for y = y1 to y2 - 1 do
      f (x, y)
    done
  done

let foldl2d f v0 ((x1, y1), (x2, y2)) =
  let v = ref v0 in
    for y = y1 to y2 - 1 do
      for x = x1 to x2 - 1 do
	v := f (x, y) !v
      done
    done;
    !v

let foldr2d f v0 ((x1, y1), (x2, y2)) =
  let v = ref v0 in
    for y = y2 - 1 downto y1 do
      for x = x2 - 1 downto x1 do
	v := f (x, y) !v
      done
    done;
    !v

let time f v =
  let t0 = Unix.gettimeofday () in
  let r = f v in
  let t1 = Unix.gettimeofday () in
    t1 -. t0, r
