let rec fold_n f v0 n =
  if n > 0 then
    fold_n f (f v0) (n - 1)
  else
    v0

let not1 f a = not (f a)

let in_list l =
  let h = Hashtbl.create 10 in
    List.iter (fun n -> Hashtbl.add h n ()) l;
    fun k -> Hashtbl.mem h k

let const a b =
  a

let unopt o =
  match o with
    | None -> assert false
    | Some x -> x
 
let uniq compare l =
  let rec loop l =
    match l with
      | x::y::xs when compare x y = 0 ->
	  loop (x::xs)
      | x::xs -> x::loop xs
      | l -> l
  in
    loop l

let rec take_n n l =
  if n > 0 then
    match l with
      | x::xs ->
	  x::(take_n (n - 1) xs)
      | [] -> []
  else
    []

let random_n n max =
  let nums = snd (fold_n (fun (n, l) -> (n + 1, (Random.float 1.0, n)::l) ) (0, []) max) in
    take_n n (List.map snd (List.sort compare nums))

let map_with_indices f xls ils =
  let rec loop at xls ils =
    match xls with
      | [] -> []
      | x::xls ->
	  let cont = loop (at + 1) xls in
	    match ils with
	      | i::ils when i = at -> f x true::cont ils
	      | ils -> f x false::cont ils
  in
    loop 0 xls ils

(*
  let rec loop at ils xs =
    match xs with
      | x::xs ->
	  let (filter, el) = p x ->
	    if filter then
	      match ils with
		| _, [] -> []
		| i::ils when i = at -> f x true::loop (at + 1) ils xs
		| ils -> f x false::loop (at + 1) ils xs 
	    else
	      
  in
    loop 0 ils xs
*)      

let fold_map iter f accu =
  (* workaround for Objective Caml version 3.08.1 bug *)
  let accu = ref accu in
    iter 
      (fun key value ->
	accu := f key value !accu);
    !accu

