open Math

class obj ?base (x0, y0) bitmaps =
  let bitmap_dims = 
    let si = Sdlvideo.surface_info (List.hd bitmaps) in
      (si.Sdlvideo.w, si.Sdlvideo.h)
  in
  let round2 (x, y) =
    int_of_float (x +. 0.5), int_of_float (y +. 0.5) in
  let center (x, y) =
    match bitmap_dims with (w, h) -> x -. float_of_int w /. 2.0, y -. float_of_int h /. 2.0
  in
  let translate, translate' =
    (fun at -> match at, base with
      | at, None -> at
      | at, Some ofs -> at +.| ofs),
    (fun at -> match at, base with
      | at, None -> at
      | at, Some ofs -> at -.| ofs)
  in
object (self)
  val mutable at = x0, y0
  val images = bitmaps
  val mutable under = None

  method where = at

  method undraw (gfx:Gfx.t) = 
    match under with
      | None -> ()
      | Some (at, bitmap) ->
	  gfx#blit ~sync:false at bitmap;
	  under <- None

  method translate at = translate at

  method translate' at = translate' at

  method draw grab_under (gfx:Gfx.t) =
    if grab_under then 
      under <- Some ((round2 (center at)), gfx#grab (round2 (translate (center at))) bitmap_dims);
    List.iter (gfx#blit ~sync:false (round2 (translate (center at)))) images

  method move_rel f =
    at <- f at

  method clone =
    new obj ?base at bitmaps

  method other_bitmap bitmaps =
    new obj ?base at bitmaps
end
