open Math

type t =
    { gfx	: Gfx.t;
      mid	: Control.mid;
      bitmap	: Sdlvideo.surface;
      hotspot	: int * int }

let create (gfx : Gfx.t) file hotspot =
  let s = Sdlloader.load_image file in
  let { Sdlvideo.w = w; h = h } = Sdlvideo.surface_info s in
  let module A = Bigarray.Array1 in
  let image = 
    A.create Bigarray.int32 Bigarray.c_layout (w * h) in
  let src x y = Sdlvideo.get_pixel s x y in
  let dst x y v = A.set image (x + y * w) v in
  let key = src 0 0 in
  let alpha = 0x00000000l in
    for x = 0 to w - 1 do
      for y = 0 to h - 1 do
	dst x y 
	  (let v = src x y in
	     if v = key then
	       alpha
	     else
	       Int32.logor 0xff000000l (Int32.logand 0x00ffffffl v);

	  )
      done;
      done;
      {
	gfx = gfx;
	mid = Control.new_mid ();
	bitmap = gfx#formatted  ~alpha:true (Sdlvideo.create_RGB_surface_from_32 image ~w ~h ~pitch:(w * 4) ~rmask:0x00ff0000l ~gmask:0x0000ff00l ~bmask:0x000000ffl ~amask:0xff000000l);
	hotspot = hotspot;
      }
	
let draw t delta =
  let (x, y, _) = t.gfx#get_mouse () in
    t.gfx#blit ((x, y) -| t.hotspot) t.bitmap;
    [Control.renew]

let stop t =
  [Control.unset t.mid]

let start t =
  [Control.set_tick ~mid:t.mid ~layer:(Control.layer 10) (draw t)]
