module type MESSAGE =
sig
  type t
end

module Queue =
  functor (M : MESSAGE) ->
    struct
      type message = M.t
      type queue = { queue : message list ref }

      let create () = { queue = ref [] }

      let send t msg = t.queue := msg::!(t.queue)

      let receive t =
	match !(t.queue) with
	  | [] -> None
	  | x::xs ->
	      t.queue := xs;
	      Some x
    end

type message = 
    | MsgStartGame
    | MsgQuit
    | MsgGameOver
    | MsgPoints of int

type t = 
    { queue : message list ref }

let create () = { queue = ref [] }

let send t msg = t.queue := msg::!(t.queue)

let receive t =
  match !(t.queue) with
    | [] -> None
    | x::xs ->
	t.queue := xs;
	Some x

