open Utils
open Math

type entry =
    { e_surface	: Sdlvideo.surface;
      e_msg     : MoxMessages.Msg.t }

type t =
    { entries	: entry list;
      gfx	: Gfx.t;
      selected  : int option ref;
      mid	: Control.mid;
      messages  : MoxMessages.queue;
    }

let create (gfx : Gfx.t) messages =
  { entries =
      [{ e_surface = gfx#text_surface "Uus peli";
	 e_msg = MoxMessages.Msg.StartGame };
       { e_surface = gfx#text_surface "Poistu";
	 e_msg = MoxMessages.Msg.Quit };
      ];
    gfx = gfx;
    selected = ref None;
    mid = Control.new_mid ();
    messages = messages;
  }

let iter_entries t f =
  let x_center = 500 / 2 in
    ignore (
	List.fold_left
	  (fun (n, y) entry ->
	    let (w, _) = Gfx.surface_dims entry.e_surface in
	    let at = (x_center - w / 2, y) in
	      f n at entry;
	      (n + 1, y + 60)
	  )
	  (0, 100)
	  t.entries
      )
      
let rec display_menu t delta =
  iter_entries t 
    (fun n at entry ->
      if Some n = !(t.selected) then
      	let size = Gfx.surface_dims entry.e_surface in
	  t.gfx#rectangle (80, 40, 160) at size);
  iter_entries t
    (fun n at entry ->
      t.gfx#blit at entry.e_surface);
  [Control.renew]

let rec update_selected t pointer =
  t.selected := None;
  iter_entries t
    (fun n at entry ->
      let size = Gfx.surface_dims entry.e_surface in
	if inside (at, at +| size) pointer then
	  t.selected := Some n;
    );
  [Control.renew]

let stop t =
  [Control.unset t.mid]

let rec choose_entry t pointer =
  begin
    ignore (update_selected t pointer);
    match !(t.selected) with
      | Some n ->
	  MoxMessages.send t.messages ((List.nth t.entries n).e_msg);
      | None -> ()
  end;
  [Control.renew]

let rec start t =
  [Control.set_tick ~layer:(Control.layer 5) ~mid:t.mid (display_menu t);
   Control.set_move ~mid:t.mid (update_selected t);
   Control.set_click ~mid:t.mid (choose_entry t)
  ]
