type vector = float * float

(* vector math *)
val ( +.| ) : vector -> vector -> vector
val ( -.| ) : vector -> vector -> vector
val ( +| ) : int * int -> int * int -> int * int
val ( -| ) : int * int -> int * int -> int * int
val ( /.| ) : vector -> float -> vector
val ( *.| ) : vector -> float -> vector
val ( *.|| ) : vector -> (vector) * (vector) -> vector
val dot : vector -> vector -> float
(* is point inside provided rectangle? *)
val inside : ('a * 'b) * ('a * 'b) -> 'a * 'b -> bool

val pow2 : float -> float

(* pythagora's *)
val distance : vector -> float

val coaxel : 'a * float -> float * 'a
val base : 'a * float -> ('a * float) * (float * 'a)

(* inverse matrix *)
val inverse : (vector) * (vector) -> (vector) * (vector)

(* utility *)
val float2 : int * int -> vector
val int_of_float2 : vector -> int * int
val format_float2 : vector -> Format.formatter -> unit

(* is the distance between points less than provided? *)
val collide : vector -> vector -> float -> vector option -> bool

(* distance' delta speed ratio 

   distance between two points. compresses the space between points
   not in the direction of the speed by ratio *)
val distance' : vector -> vector -> float -> float

(* collision that uses distance' *)
val collide' : vector -> vector -> float -> vector -> float -> bool

val reflect : vector * vector -> vector * float -> vector * vector

val intersect_line_circle : vector * vector -> vector * float -> (vector * vector) option

val faces : vector -> vector -> bool
