class t (gfx:#Gfx.t) (x0, y0) =
object (self)
  val mutable under = None
  val mutable surface = None
  val mutable message = ""

  method get_surface () =
    match surface with
      | Some s-> 
	  s
      | None ->
	  let s = (Sdlttf.render_text_solid (gfx#get_font ()) message (255, 255, 255)) in
	    surface <- Some s;
	    s

  method set_text ~sync text =
    self#undraw ~sync ();
    surface <- None;
    message <- text
    self#draw ~sync ()

  method draw ~sync () =
    gfx#blit ~sync (x0, y0) (self#get_surface ())

  method undraw ~sync () =
    match under with
      | None -> ()
      | Some s -> 
	  gfx#blit ~sync (x0, y0) s;
	  under <- None
end

