type entry = 
    { e_xy : int * int;
      e_ch : char;
      e_surf : Sdlvideo.surface;
      e_under : Sdlvideo.surface } 

type input_response =
    | InputKeepOn
    | InputLine of string

class t (gfx:#Gfx.t) (x0, y0) =
  let draw_entry e = gfx#blit e.e_xy e.e_surf in
  let draw_entries ents = List.iter draw_entry ents in

  let erase_entry ent =
    gfx#blit ~sync:true ent.e_xy ent.e_surf in

  let after_entries ents =
    match ents with
      | { e_xy = x, y;
	  e_surf = surf } :: _ -> 
	  ( match Sdlvideo.surface_info surf with
	    | { Sdlvideo.w = w; h = _h } -> (x + w, y) )
      | _ -> 
	  (x0, y0) in

  let blink_cycle = 0.5 in
    
object (self)
  val mutable before : entry list = []
  val mutable after : entry list = []
  val mutable cursor_hides : ((int * int) * Sdlvideo.surface) option = None
  val mutable last_blink : float = 0.0

  method cursor_blink_on ?(sync=true) () =
    if cursor_hides = None then
      let (x, y) = after_entries before in
      let (w, h) = 2, 22 in
	cursor_hides <- Some ((x, y), gfx#grab (x, y) (w, h));
	gfx#rectangle ~sync (255, 255, 255) (x, y) (w, h)

  method cursor_blink_off ?(sync=true) () =
    match cursor_hides with
      | Some (at, under) ->
	  cursor_hides <- None;
	  gfx#blit ~sync at under
      | None -> ()

  method cursor_blink ?(sync=true) () =
    let now = Unix.gettimeofday () in
      if mod_float now blink_cycle < blink_cycle /. 2.0 then
	self#cursor_blink_on ~sync ()
      else
	self#cursor_blink_off ~sync ()

  method next_cursor_blink =
    let now = Unix.gettimeofday () in
      now +. ((blink_cycle /. 2.0) -. mod_float now (blink_cycle /. 2.0))
      
  method refresh () = 
    draw_entries before;
    draw_entries after

  method add_char ch =
    self#cursor_blink_off ~sync:false ();
    let x, y = after_entries before in
    let s = Sdlttf.render_text_solid (gfx#get_font ()) (String.make 1 ch) (255, 255, 255) in
      match Sdlvideo.surface_info s with { Sdlvideo.w = w; h = h } ->
	let entry = { e_xy = x, y; e_ch = ch; e_surf = s; e_under = gfx#grab (x, y) (w, h) } in
          before <- entry :: before;
	  draw_entry entry;
	  gfx#sync ~rect:(Sdlvideo.rect ~x ~y ~w ~h) ();

  method left () =
    match before with
      | x::xs ->
          before <- xs; after <- x::after
      | [] -> ()

  method right () =
    match after with
      | x::xs ->
          after <- xs; before <- x::before
      | [] -> ()

  method backspace () =
    match before with
      | x::xs ->
	  before <- xs;
	  self#cursor_blink_off ();
	  erase_entry x
      | _ -> ()

  method get_line =
    let ch { e_ch = ch } = ch in
    let l = 
      List.concat 
	[List.rev (List.map ch before);
	 List.map ch after] in
    let rec build s at l =
      match l with 
	| x::xs ->
	    s.[at] <- x;
	    build s (at + 1) xs
	| [] -> s
    in
      build (String.make (List.length l) ' ') 0 l
	  
  method handle_event event =
    match event with
      | Sdlevent.KEYDOWN x -> 
	  ( match x with 
	    | { Sdlevent.keysym = Sdlkey.KEY_BACKSPACE } -> 
		Printf.printf "plop\n%!";
		self#backspace ();
		InputKeepOn
	    | { Sdlevent.keysym = Sdlkey.KEY_RETURN } -> 
		InputLine self#get_line
	    | { Sdlevent.keysym = sym;
		keymod = kmod } when 
		  Sdlkey.int_of_key sym < 256 &&
		    Sdlkey.char_of_key sym <> Char.chr 0 ->
		let ch = Sdlkey.char_of_key sym in
		let ch = 
		  if kmod land (Sdlkey.kmod_lshift lor Sdlkey.kmod_rshift) <> 0 then
		    Char.uppercase ch
		  else
		    ch
		in
		  self#add_char ch;
		  InputKeepOn
	    | _ -> InputKeepOn )
      | _ -> InputKeepOn
end
