type t = 
    {
      from_bitmap	: Sdlvideo.surface;
      to_bitmap		: Sdlvideo.surface;
      ratio		: float ref;
    }

let create bm_from bm_to =
  { from_bitmap = bm_from;
    to_bitmap = Gfx.dup_surface [`SRCALPHA] bm_to;
    ratio = ref 0.0 }

let adjust_ratio t f =
  let v = f !(t.ratio) in
    t.ratio := v;
    v

let draw t at (gfx : #Gfx.t) =
  gfx#blit at t.from_bitmap;
  Sdlvideo.set_alpha t.to_bitmap (int_of_float (0.5 +. 255.0 *. (max 0.0 (min 1.0 !(t.ratio)))));
  gfx#blit at t.to_bitmap
  
