open VecOps
open GobaUtils

class virtual t =
object (this : 'a)
  method virtual collision_area : ((float * float) * (float * float)) * CollisionMask.mask
end

(* 'negative' areas not considered *)
let collide_range : (float * float) -> (float * float) -> bool =
  fun (a1, b1) (a2, b2) ->
(*  Printf.printf "Collides? %f,%f with %f,%f\n%!" a1 b1 a2 b2;*)
    (a1 < a2 && b1 > a2) || (a1 >= a2 && a1 <= b2)

(* O(n).. *)
let collisions : #t -> #t list -> (#t -> bool) -> #t list =
  fun obj1 objs filter ->
    let b1, m1 = obj1#collision_area in
      List.fold_left 
	(fun collides obj2 ->
	   let b2, m2 = obj2#collision_area in
	   let ((b1'x1, b1'y1), (b1'x2, b1'y2)) = b1 in
	   let ((b2'x1, b2'y1), (b2'x2, b2'y2)) = b2 in
	   let x_collision = collide_range (b1'x1, b1'x2) (b2'x1, b2'x2) in
	   let y_collision = collide_range (b1'y1, b1'y2) (b2'y1, b2'y2) in
	     if 
	       x_collision && y_collision && filter obj2 &&
		 CollisionMask.collides 
		 (int_of_float2 (fst b1), m1) 
		 (int_of_float2 (fst b2), m2)
	     then
	       obj2::collides
	     else
	       collides
	)
	[]
	objs

let collisions2 : #t -> #t list -> (#t -> bool) -> ((float * float) * #t list) option =
  fun obj1 objs filter ->
    let b1, m1 = obj1#collision_area in
      List.fold_left 
	(fun collides obj2 ->
	   let b2, m2 = obj2#collision_area in
	   let ((b1'x1, b1'y1), (b1'x2, b1'y2)) = b1 in
	   let ((b2'x1, b2'y1), (b2'x2, b2'y2)) = b2 in
	   let x_collision = collide_range (b1'x1, b1'x2) (b2'x1, b2'x2) in
	   let y_collision = collide_range (b1'y1, b1'y2) (b2'y1, b2'y2) in
	     if x_collision && y_collision && filter obj2 then
	       match 
		 CollisionMask.collides2 
		   (int_of_float2 (fst b1), m1) 
		   (int_of_float2 (fst b2), m2),
		 collides
	       with
		 | Some fix, None -> Some (fix, [obj2])
		 | Some fix, Some (_old_fix, objs) -> Some (fix, obj2::objs)
		 | None, _ -> collides
	     else
	       collides
	)
	None
	objs
